/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.SDKFileEditorUI;
import com.quantumdata.quantumdatasdk.SDKOutputTab;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class SDKOutputManager
extends JPanel {
    private static final JTabbedPane pane = new JTabbedPane();
    private static String[] outputTitles = new String[]{"  Compile Output", "  Connection Output"};

    public SDKOutputManager() {
        this.setLayout(new BorderLayout());
        pane.removeAll();
        this.addAll();
        pane.setTabLayoutPolicy(0);
        this.add(pane);
    }

    private void addAll() {
        this.addCompileOutputTab();
        this.addConnectOutputTab();
    }

    private void addCompileOutputTab() {
        SDKOutputTab sDKOutputTab = new SDKOutputTab();
        pane.addTab(outputTitles[0], null, sDKOutputTab, "Compile Output");
        pane.setUI(new SDKFileEditorUI());
    }

    private void addConnectOutputTab() {
        SDKOutputTab sDKOutputTab = new SDKOutputTab();
        pane.addTab(outputTitles[1], null, sDKOutputTab, "Connection Output");
        pane.setUI(new SDKFileEditorUI());
    }

    public JTextArea getTabTextArea(String string) {
        for (int i = 0; i < pane.getComponentCount(); ++i) {
            if (!pane.getTitleAt(i).contains(string) || !(pane.getComponentAt(i) instanceof SDKOutputTab)) continue;
            SDKOutputTab sDKOutputTab = (SDKOutputTab)pane.getComponentAt(i);
            pane.setSelectedIndex(i);
            return sDKOutputTab.getTextArea();
        }
        return this.addTabAndGetTextArea(string);
    }

    private JTextArea addTabAndGetTextArea(String string) {
        SDKOutputTab sDKOutputTab = new SDKOutputTab();
        if (string.compareToIgnoreCase(ConfigData.sOutputTabs[0]) == 0) {
            pane.addTab(outputTitles[0], null, sDKOutputTab, "Compile Output");
        } else if (string.compareToIgnoreCase(ConfigData.sOutputTabs[1]) == 0) {
            pane.addTab(outputTitles[1], null, sDKOutputTab, "Connection Output");
        } else {
            return null;
        }
        pane.setUI(new SDKFileEditorUI());
        pane.setSelectedComponent(sDKOutputTab);
        return sDKOutputTab.getTextArea();
    }
}

